/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.contraptions.components.actor;

import com.farmersrespite.common.block.CoffeeDoubleStemBlock;
import com.farmersrespite.common.block.CoffeeMiddleStemBlock;
import com.farmersrespite.common.block.TeaBushBlock;
import com.farmersrespite.core.registry.FRBlocks;
import com.farmersrespite.core.registry.FRItems;
import com.simibubi.create.content.contraptions.components.actors.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import plus.dragons.createcentralkitchen.content.contraptions.components.actor.HarvesterMovementBehaviourExtension;
import plus.dragons.createcentralkitchen.foundation.utility.ModLoadSubscriber;

@ModLoadSubscriber(modid="farmersrespite")
public class FRHarvesterMovementBehaviourExtensions {
    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)FRBlocks.TEA_BUSH.get(), FRHarvesterMovementBehaviourExtensions::harvestTeaBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)FRBlocks.COFFEE_STEM.get(), FRHarvesterMovementBehaviourExtensions::harvestCoffeeStem);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)FRBlocks.COFFEE_STEM_MIDDLE.get(), FRHarvesterMovementBehaviourExtensions::harvestCoffeeMiddleStem);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)FRBlocks.COFFEE_STEM_DOUBLE.get(), FRHarvesterMovementBehaviourExtensions::harvestCoffeeDoubleStem);
        });
    }

    public static void harvestTeaBush(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        Level level = context.world;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)TeaBushBlock.HALF);
        if (replant && half == DoubleBlockHalf.UPPER) {
            switch ((Integer)state.m_61143_((Property)TeaBushBlock.AGE)) {
                case 0: {
                    behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.GREEN_TEA_LEAVES.get(), 2 + level.f_46441_.nextInt(2)));
                    break;
                }
                case 1: {
                    behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), 2 + level.f_46441_.nextInt(2)));
                    break;
                }
                case 2: {
                    behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), 1 + level.f_46441_.nextInt(2)));
                    behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.BLACK_TEA_LEAVES.get(), 1 + level.f_46441_.nextInt(2)));
                    break;
                }
                case 3: {
                    behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.BLACK_TEA_LEAVES.get(), 2 + level.f_46441_.nextInt(2)));
                }
            }
            behaviour.dropItem(context, new ItemStack((ItemLike)Items.f_42398_, 2 + level.f_46441_.nextInt(2)));
            level.m_46597_(pos.m_7495_(), ((Block)FRBlocks.SMALL_TEA_BUSH.get()).m_49966_());
        } else {
            BlockPos destroyPos = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
            BlockHelper.destroyBlock((Level)level, (BlockPos)destroyPos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
        }
    }

    private static void destroyCoffeeStems(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos rootPos, BlockState rootState, BlockPos middlePos, BlockState middleState, boolean partial) {
        Level level = context.world;
        int rootAge0 = (Integer)rootState.m_61143_((Property)CoffeeDoubleStemBlock.AGE);
        int rootAge1 = (Integer)rootState.m_61143_((Property)CoffeeDoubleStemBlock.AGE1);
        int middleAge = (Integer)middleState.m_61143_((Property)CoffeeMiddleStemBlock.AGE);
        if (partial ? rootAge0 < 2 && rootAge1 < 2 && middleAge < 2 : rootAge0 < 2 || rootAge1 < 2 || middleAge < 2) {
            return;
        }
        BlockHelper.destroyBlock((Level)level, (BlockPos)middlePos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
        BlockHelper.destroyBlock((Level)level, (BlockPos)rootPos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
    }

    public static void harvestCoffeeStem(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61406_) < 2) {
            return;
        }
        Level level = context.world;
        if (replant) {
            behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.COFFEE_BERRIES.get(), 1));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.nextFloat() * 0.4f);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0)));
        } else {
            BlockHelper.destroyBlock((Level)level, (BlockPos)pos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
        }
    }

    public static void harvestCoffeeMiddleStem(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        if (replant) {
            FRHarvesterMovementBehaviourExtensions.harvestCoffeeStem(behaviour, context, pos, state, true, partial);
        } else {
            BlockPos posBelow = pos.m_7495_();
            BlockState stateBelow = context.world.m_8055_(posBelow);
            if (stateBelow.m_60734_() instanceof CoffeeDoubleStemBlock) {
                FRHarvesterMovementBehaviourExtensions.destroyCoffeeStems(behaviour, context, posBelow, stateBelow, pos, state, partial);
            }
        }
    }

    public static void harvestCoffeeDoubleStem(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        if (replant) {
            int count1;
            int count0 = (Integer)state.m_61143_((Property)CoffeeDoubleStemBlock.AGE) == 2 ? 1 : 0;
            int count = count0 + (count1 = (Integer)state.m_61143_((Property)CoffeeDoubleStemBlock.AGE1) == 2 ? 1 : 0);
            if (count == 0) {
                return;
            }
            Level level = context.world;
            behaviour.dropItem(context, new ItemStack((ItemLike)FRItems.COFFEE_BERRIES.get(), count));
            BlockState newState = state;
            if (count0 == 1) {
                newState = (BlockState)state.m_61124_((Property)CoffeeDoubleStemBlock.AGE, (Comparable)Integer.valueOf(0));
            }
            if (count1 == 1) {
                newState = (BlockState)state.m_61124_((Property)CoffeeDoubleStemBlock.AGE1, (Comparable)Integer.valueOf(0));
            }
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.nextFloat() * 0.4f);
            level.m_46597_(pos, newState);
        } else {
            BlockPos posAbove = pos.m_7494_();
            BlockState stateAbove = context.world.m_8055_(posAbove);
            if (stateAbove.m_60734_() instanceof CoffeeMiddleStemBlock) {
                FRHarvesterMovementBehaviourExtensions.destroyCoffeeStems(behaviour, context, pos, state, posAbove, stateAbove, partial);
            }
        }
    }
}

